// bergmark - spring 1999 - telephony project

// AddMessage.java: ITX directory application to add a message
// to the directory entry for the user who launched this program.
// The user must already be in the directory (see AddNewUser).

// Caution: very insecure.  Password is given either on the argument line
//          or typed into the keyboard.  Sorta matches directory, though.

// Usage:  java AddMessage [ userid | [ password ]]  

import cnrg.itx.signal.*;

import java.io.*;

public class AddMessage extends AbstractSignalingObserver {

	private DesktopSignaling myDS = null;
	private String id_string;  // userid
	private String pw_string;  // password
	private BufferedReader input = null;

	public static void main (String[] args)
	{	
		AddMessage msg_addr = new AddMessage (args);

		// Have a DesktopSignaling, a Directory Entry,
		// and an open data input stream.
		// Get the message and stash it

		System.out.println ("Enter custom message:");
		try {
		System.out.println ("Current Message: " +
		   msg_addr.myDS.getDirectory().getCustomMessage() );
			msg_addr.myDS.getDirectory ().setCustomMessage (msg_addr.input.readLine ());
		} catch (Exception e) {
			System.out.println ("Failed to add the message because " + e.toString ());
		}
		System.exit(0);
	}

	// Constructor establishes a DesktopSignaling 
	public AddMessage (String[] args)
	{
		// Open input
		input = openInput();

		// Get the username
		id_string = getArg (args, 0, "Enter app-name or username@address:");

		// Get the password
		pw_string = getArg ( args, 1, "Enter password:" );

		// Get the Desktop Signaling
		System.out.println ("Trying: " + "myDS = new DesktopSignaling ( this, " + id_string + ", " + pw_string +")");
		try {
			myDS = new DesktopSignaling ( this, id_string, pw_string );
		} catch ( Exception e ) {
			System.out.println ("/n/nSorry, you couldn't lookup an existing " + "directory entry because " + e.toString() );
			System.exit (0);
		}

	}

	private BufferedReader openInput () {
		try {
			return new BufferedReader (new InputStreamReader (System.in));
		} catch ( Exception e ) {
			System.out.println ("Could not open input because " + e.toString() );
			System.exit(0);
		}
		return null;
	}

	private String getArg ( String[] args, int i, String prompt ) {
		if ( args.length > i )
			return args[i];
		else {
			System.out.println (prompt);
			try {
				return input.readLine();
			} catch ( Exception e ) {
				System.out.println ("Could not read in because " + e.toString() );
			}
		}
		return "";
	}
}
